;****************************************************************************************
;*                           LCD-LAUFTEXT VON DL3UKH                                  * 
;*                           =========================                                  *
;*                                                                                      *
;****************************************************************************************

        LIST    P=16F88       
        TITLE   "LAUFTEXT"

        ERRORLEVEL -302
        INCLUDE <P16F88.INC>

__CONFIG _CONFIG1, _CP_OFF & _CCPMX_RB0 & _DEBUG_OFF & _WRT_OFF & _CPD_OFF & _LVP_OFF & _BOREN_OFF & _MCLRE_OFF & _PWRTE_OFF & _WDTE_OFF & _INTRC_IO
__CONFIG _CONFIG2, _IESO_OFF & _FCMEN_OFF


;--------------------------------------------------------------------------
;REGISTER ZUORDNEN NACH DEM DIE FESTEN-REGISTER ZU ENDE SIND
;ES GEHT ALSO ERST AB 22 HEX LOS
;DIES IST ALSO DIE RAM-SPEICHER ZUORDNUNG

HELP0   EQU 0X22       ;HILFSZELLE
HELP1   EQU 0X23       ;HILFSZELLE

;FUER 4-BIT
HELP2   EQU 0X24       ;HILFSZELLE
MERKE   EQU 0X25       ;HILFSZELLE
BIT     EQU 0X26       ;HILFSZELLE

;FR LAUFSCHRIFT
TXT     EQU 0X27
ZAE     EQU 0X28
LCD_ADR EQU 0X29
DAUER   EQU 0X2A
NR      EQU 0X2B
NR_HELP EQU 0X2C
ZEILE   EQU 0X2D
NEU     EQU 0X2E
AUSWAHL EQU 0X2F

;ANALOG/DIGITAL-WANDLUNG
AD_H    EQU 0X30
AD_L    EQU 0X31



;------------------------- MACROS -----------------------------------------

BANK0           MACRO                   ;MACRO TO SELECT DATA RAM BANK 0
                BCF     STATUS,RP0
                BCF     STATUS,RP1
                ENDM

BANK1           MACRO                   ;MACRO TO SELECT DATA RAM BANK 1
                BSF     STATUS,RP0
                BCF     STATUS,RP1
                ENDM

BANK2           MACRO                   ;MACRO TO SELECT DATA RAM BANK 2
                BCF     STATUS,RP0
                BSF     STATUS,RP1
                ENDM

BANK3           MACRO                   ;MACRO TO SELECT DATA RAM BANK 3
                BSF     STATUS,RP0
                BSF     STATUS,RP1
                ENDM

;VARIABLEN
BIT7    EQU 7       ; BIT 7
BIT6    EQU 6       ; BIT 6
BIT5    EQU 5       ; BIT 5
BIT4    EQU 4       ; BIT 4
BIT3    EQU 3       ; BIT 3 
BIT2    EQU 2       ; BIT 2
BIT1    EQU 1       ; BIT 1 
BIT0    EQU 0       ; BIT 0


;==================================================
RS      EQU 2       ; PORTA BIT2 UMSCHALTEN BEFEHL/DATEN      BEI WRITE DATEN IST ES HIGH
EN      EQU 3       ; PORTA BIT3 ENABLE FALLENDE FLANKE
;==================================================

ANZAHL  EQU D'8'    ; DISPLAY ZEICHEN ANZAHL
ANZAHL1 EQU D'9'    ; DISPLAY ZEICHEN ANZAHL PLUS 1
;==================================================
;-----------------------------------------------------------------------------
;SPEICHERANFANG BZW. BEGINN

                ORG 0X0000
                GOTO MAIN               ; SPRUNG ZUM HAUPTPROGRAMM
                ORG 0X0004
                RETFIE                  ; BEI EINEM INTERRUPT SOFORT EIN RETURN

                ORG 0X0010
;*****************************************************************************
;*                              HAUPTPROGRAMM                                *
;*                              22.09.11                                     *
;*****************************************************************************
MAIN            CLRF    PORTA                           
                CLRF    PORTB

;----------- INIT ALLE PORT'S ----------------------------------------------------

                BANK1
                MOVLW   B'01111110'             ;0110-8MHZ INTERN-RC / 1-VOM SYSTEM / 1-STABILE FREQUENZ / 1-RC-TAKT-INTERN FUER SYSTEM
                MOVWF   OSCCON

                MOVLW   0X07                    ;COMPARATORS ALLE AUS VOM PORT A
                MOVWF   CMCON

                MOVLW   B'11110011'             ;INIT INPUT/OUTPUT AM PORTA --> ALLES EINGAENGE AUSSER  RA2 RA3 ALS AUSGAENGE B'00111100' 
                MOVWF   TRISA
                MOVLW   B'00001111'             ;INIT I/O PORTB  ALLES AUSGANG 
                MOVWF   TRISB

;INIT TIMER 0 FUER 1MSEC
                MOVLW   B'10000100'             ;BIT0-2 1=PRESCALER32, BIT3 0=TMR0, BIT4 0=ENTFAELLT, BIT5 0=TAKT VOM SYSTEM, BIT6 0=KEIN RB-INTERRUPT, BIT7 1=PULL-UPS DISABLE 
                MOVWF   OPTION_REG

;AD-INIT
                MOVLW   B'00010000'  ;RA4 ALS AD4/AN4
                MOVWF   ANSEL
;AD-INIT
                MOVLW   B'10000000'  ;RECHTSBNDIG B1 / FOSZ=32 B0 / VSS+VDD REF-SPANNUNG B00
                MOVWF   ADCON1
                BANK0

;AD-INIT
                MOVLW   B'11100001'  ;FOSZ=RC B11 / AD4 B100 / GO-IST AUS + ON IST EIN B001
                MOVWF   ADCON0

;ZEITSCHLEIFE VON 100MSEC, MUSS SEIN WEGEN ANSCHALTEN, DANN ERST DIE ERSTEN BEFEHLE
            MOVLW   D'100'
            CALL    ZS1MS

            MOVLW   D'2'
            MOVWF   HELP0

INIT
;INITIALISIERUNG DOT-MATRIX-LCD
            ;MOVLW   H'20'                   ;FUNCTION SET  NUR HHERES BYTE
            ;CALL    BEFEHL

            MOVLW   H'21'                   ;FUNCTION SET  4-BIT-LAENGE, 1-ZEILIG, 5X7FONT
            CALL    BEFEHL
 
            MOVLW   H'1C'                   ;BIAS SET
            CALL    BEFEHL
 
            MOVLW   H'51'                   ;BOOSTER OFF CONTRAST
            CALL    BEFEHL
 
            MOVLW   H'6A'                   ;SET VOLTAGE
            CALL    BEFEHL
 
            MOVLW   H'74'                   ;CONTRAST SET
            CALL    BEFEHL

            MOVLW   H'20'                   ;FUNCTION SET  4-BIT-LAENGE, 1-ZEILIG, 5X7FONT
            CALL    BEFEHL
 
            MOVLW   H'0C'                   ;DISPLAY ON/OFF   DISPLAY ON, CURSOR OFF, BLINK OFF
            CALL    BEFEHL

            DECFSZ  HELP0, F
            GOTO    INIT

;----------- AN DOG-MATRIX-AUSGEBEN ------------------------

ANFANG
            CALL    AD_ZS


            MOVLW   H'01'                   ;CLEAR DISPLAY
            CALL    BEFEHL

;ZEITSCHLEIFE VON 2MSEC, MUSS SEIN WEGEN LSCHEN
            MOVLW   D'2'
            CALL    ZS1MS    

;DIP-SCHALTER FR TEXTAUSWAHL ABFRAGEN
            MOVF    PORTA, W
            ANDLW   0X03
            MOVWF   AUSWAHL

                    CLRF    ZAE             ;ZAE ZHLER MIT BEGINN NULL LADEN
                    CLRF    NR_HELP         ;AUCH NR
                    CLRF    ZEILE
                    CLRF    NEU 
                    MOVLW   D'1'
                    MOVWF   NR
                    
NEUES_ZEICHEN       CALL    TABELLE
                    MOVWF   TXT
                    MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH AM ANFANG /// *.LST FILE ADRESSE KONTROLLIEREN !!!!
                    MOVWF   PCLATH

                    MOVLW   0XFF            ;TXT-ENDE-ERKENNUNG
                    SUBWF   TXT, W
                    BTFSC   STATUS, Z
                    GOTO    ANFANG         ;SCHLUSS / ES HAT DAS 0XFF ERKANNT ALS ENDEKENNZEICHEN IN DER TABELLE

;AUF DOGM ANZEIGEN
                    MOVF    NR, W
                    SUBLW   H'87'
                    MOVWF   LCD_ADR

WEITER3             INCF    LCD_ADR, F
                    INCF    ZAE, F

                    MOVF    LCD_ADR, W          ;NEUES HINZUGEKOMMENES ZEICHEN
                    CALL    BEFEHL
                    MOVF    TXT, W
                    CALL    DATEN

                    BTFSS   ZEILE, BIT0
                    GOTO    WEITER1

                    MOVF    ZAE, W
                    SUBLW   ANZAHL1 
                    BTFSC   STATUS, Z
                    GOTO    VOLL                ;ZEILE VOLL

                    INCF    NR_HELP, F
                    CALL    TABELLE
                    MOVWF   TXT
                    MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH AM ANFANG /// *.LST FILE ADRESSE KONTROLLIEREN !!!!
                    MOVWF   PCLATH

                    MOVLW   0XFF            ;TXT-ENDE-ERKENNUNG
                    SUBWF   TXT, W
                    BTFSC   STATUS, Z
                    GOTO    ANFANG         ;SCHLUSS / ES HAT DAS 0XFF ERKANNT ALS ENDEKENNZEICHEN IN DER TABELLE

                    GOTO    WEITER3


;ENDE ERKENNUNG FR ZEILE BESCHREIBEN
WEITER1             MOVF    ZAE, W
                    SUBLW   ANZAHL 
                    BTFSC   STATUS, Z
                    GOTO    VOLL                ;ZEILE VOLL

                    MOVF    ZAE, W
                    SUBWF   NR, W
                    BTFSC   STATUS, Z
                    GOTO    ZEITSCHLEIFE  
                   

;NEUES ZEICHEN AUF ZEILE
WEITER4             INCF    NR_HELP, F
                    CALL    TABELLE
                    MOVWF   TXT
                    MOVLW   H'00'           ;ADRESSE SPEICHERN NEUES PCLATH AM ANFANG /// *.LST FILE ADRESSE KONTROLLIEREN !!!!
                    MOVWF   PCLATH

                    MOVLW   0XFF            ;TXT-ENDE-ERKENNUNG
                    SUBWF   TXT, W
                    BTFSC   STATUS, Z
                    GOTO    ANFANG         ;SCHLUSS / ES HAT DAS 0XFF ERKANNT ALS ENDEKENNZEICHEN IN DER TABELLE

                    GOTO    WEITER3


VOLL        BSF     ZEILE, BIT0






ZEITSCHLEIFE
            CALL    AD_ZS

;300MSEC ZEITSCHLEIFE
;            MOVLW   D'3'
;            MOVWF   DAUER
;ZEITSCHLEIFE VON 100MSEC
;DAU1        MOVLW   D'100'
;            CALL    ZS1MS

;            DECFSZ  DAUER, F
;            GOTO    DAU1







            BTFSC   ZEILE, BIT0
            GOTO    VOLLA

                    INCF    NR, F
                    CLRF    NR_HELP
                    CLRF    ZAE
                    GOTO    NEUES_ZEICHEN



VOLLA               MOVLW   D'8'
                    MOVWF   NR

                    INCF    NEU, F
                    MOVF    NEU, W
                    MOVWF   NR_HELP

                    CLRF    ZAE
                    GOTO    NEUES_ZEICHEN


;*****************************************************************************
;*                              TABELLENAUSWAHL                              *
;*****************************************************************************
TABELLE             MOVF    AUSWAHL, W
                    SUBLW   H'0' 
                    BTFSS   STATUS, Z
                    GOTO    T1
                    CALL    TABELLE_0
                    RETURN

T1                  MOVF    AUSWAHL, W
                    SUBLW   H'1' 
                    BTFSS   STATUS, Z
                    GOTO    T2
                    CALL    TABELLE_1
                    RETURN

T2                  MOVF    AUSWAHL, W
                    SUBLW   H'2' 
                    BTFSS   STATUS, Z
                    GOTO    T3
                    CALL    TABELLE_2
                    RETURN

T3                  MOVF    AUSWAHL, W
                    SUBLW   H'3' 
                    BTFSS   STATUS, Z
                    RETURN
                    CALL    TABELLE_3
                    RETURN


;*****************************************************************************
;*                              ZEITSCHLEIFE+AD-MESSUNG                      *
;*****************************************************************************
AD_ZS
                BCF     PIR1, ADIF 
                BSF     ADCON0, GO_DONE  ;GEHT LOS DIE MESSUNG

AD1             BTFSS   PIR1, ADIF
                GOTO    AD1

                BCF     ADCON0, GO_DONE  ;STOP DER MESSUNG

;AD-ERGEBNIS ABSPEICHERN IN RAM-ZELLEN AD_H UND AD_L
                MOVF    ADRESH, W
                MOVWF   AD_H
                BANK1                               
                MOVF    ADRESL, W
                BANK0                               
                MOVWF   AD_L

;---------
;1024 ZU 256 DEZ. MACHEN
                BCF     STATUS, C
                RRF     AD_H, F         ;ZU 512MAX.
                RRF     AD_L, F

                BCF     STATUS, C
                RRF     AD_H, F         ;ZU 256MAX.
                RRF     AD_L, F

                MOVLW    0X00
                SUBWF    AD_L, W
                BTFSS    STATUS, Z
                GOTO     EEE

                INCF     AD_L, F      ;UM EINS ERHHEN ALSO 0X01 FR AD_L --->WENN NULL

EEE             MOVF     AD_L, W
                CALL     ZS1MS
                MOVF     AD_L, W
                CALL     ZS1MS


;2MSEC * 256 = CA. 500MSEC
;LEUCHTET MAXIMAL 0,500SEC ALSO EIN ZYKLUS + 200MSEC = 700MSEC MAXIMAL   MINIMAL 200MSEC

;JETZT MINIMAL CA. 200MSEC 
                MOVLW   D'200'
                CALL    ZS1MS

                RETURN

;*****************************************************************************
;*                              UNTERPROG. AUSGEBEN AUF DOT-LCD-MODUL        *
;*****************************************************************************
DOGM_4      MOVWF   BIT

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB


            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'2'                    ;UNGEFAEHR 4SEC ZEITSCHLEIFE
            MOVWF   HELP2
D1          NOP                             ;T=4
            DECFSZ  HELP2, F                ;T=4
            GOTO    D1                      ;T=8    GES.:16TAKTE * 0,0625SEC= 1SEC    *4 DURCHLAEUFE= 4SEC
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;---------------------------------

;LOW 4BIT AUSGEBEN
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F
            RLF     BIT, F

            MOVF    PORTB, W
            ANDLW   0X0F
            MOVWF   MERKE

            MOVF    BIT, W
            ANDLW   0XF0
            ADDWF   MERKE, W
            MOVWF   PORTB


            BSF     PORTA, EN

;ZEITSCHLEIFE 4SEC
            MOVLW   D'2'                    
            MOVWF   HELP2
DDD1        NOP                             
            DECFSZ  HELP2, F                
            GOTO    DDD1                    
;ENDE ZEITSCHLEIFE
 
            BCF     PORTA, EN

;ZEITSCHLEIFE 27SEC
            MOVLW   D'14'                   ;UNGEFAEHR 27SEC ZEITSCHLEIFE
            MOVWF   HELP2
DDDD1       NOP
            DECFSZ  HELP2, F                ;WIE OBEN  
            GOTO    DDDD1
;ENDE ZEITSCHLEIFE

            RETURN

;*****************************************************************************
;*                              UNTERPROG. DATEN AUSGEBEN AUF DOT-LCD-MODUL  *
;*****************************************************************************
DATEN       BSF     PORTA, RS               ;ALS DATEN
            CALL    DOGM_4
            RETURN

;*****************************************************************************
;*                              UNTERPROG. BEFEHL AUSGEBEN AUF DOT-LCD-MODUL *
;*****************************************************************************
BEFEHL      BCF     PORTA, RS                ;ALS BEFEHL
            CALL    DOGM_4
            RETURN

;*****************************************************************************
;*         UNTERPROGRAMM MIT TIMER0 ALS ZEITSCHLEIFE FUER  1MSEC ....        *
;*                                                                           *
;*****************************************************************************
ZS1MS                   MOVWF   HELP0                   ;DER INHALT VON W WIRD IN "HELP1" GELADEN

T01                     MOVLW   D'193'
                        MOVWF   TMR0                    ;DER FESTE RAM-SPEICHER (TMR0) WIRD MIT 240 GELADEN
                        BCF     INTCON, TMR0IF            ;OVERFLOW = 0
                
T02                     BTFSS   INTCON, TMR0IF            ;WENN DIE ZEIT VON 10MSEC ABGELAUFEN IST, WIRD T0IF HIGH (1) UND 
                        GOTO    T02                     ;ES ERFOLGT EIN SPRUNG ZU "DECFSC MERK, F"
                        
                        DECFSZ  HELP0, F                ;ES WIRD DER WERT IN "HELP1" ABWRTS GEZHLT, BIS ER (0) IST UND
                        GOTO    T01                     ;DANN ERFOLGT EIN SPRUNG ZU "RETURN"-ENDE DES UNTERPROGRAMMS
                        RETURN

;ZEITBERECHNUNG FUER 1MS
;PRESCALER 32X  *  SYSTEM 4X  * TAKTZEIT ====> 32*4*0.125SEC=16SEC    /DIE TAKTZEIT ERGIBT SICH AUS DEM INTERNEN OSZILLATOR
;1MS : 16SEC= 62,5 GENOMMEN 63                                              /T = 1 : F  (F)-OSZILLATORFREQUENZ
;ALSO
;16S*D'63'=1,0...MSEC
;TMR0 ALSO D'256'-D'63'=D'193' ENTSPRICHT CA. 1MS
;240 DEZIMAL OBEN EINTRAGEN


    ORG 0X0300
;*****************************************************************************
;*                              UNTERPROGRAMM                                *
;*                       TEXT ZEILENWEISE ZUM BEISPIEL EINZELN LADEN         *
;*****************************************************************************
TABELLE_0
    MOVLW   H'03'       ;ADRESSE SPEICHERN NEUES PCLATH///DA OBEN ORG 0X0300 
    MOVWF   PCLATH

    MOVF    NR_HELP, W  ; SPRUNGDISTANZ
    ADDWF   PCL,F       ; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  

    
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
        
;JETZT KOMMT DER TEXT
;RETLW " "    (SPACE/LEERZEICHEN) IST DIE PAUSE ZWISCHEN DEN WOERTERN
;ES KOENNEN CA. 240 ZEILEN MIT RETLW EINGETRAGEN WERDEN /// ALSO BIS SPEICHERENDE 0X3FF /// KONTROLLIERE LIST-FILE

    RETLW "I"  
    RETLW "c"
    RETLW "h"
    RETLW " "
    RETLW "b"
    RETLW "i"
    RETLW "n"
    RETLW " "
    RETLW "d"
    RETLW "e"
    RETLW "r"
    RETLW " "
    RETLW "g"
    RETLW "r"
    RETLW  B'10010100' ;
    RETLW "s"
    RETLW "s"
    RETLW "t"
    RETLW "e"
    RETLW " "
    RETLW "B"
    RETLW "a"
    RETLW "s"
    RETLW "t"
    RETLW "l"
    RETLW "e"
    RETLW "r"
    RETLW " "
    RETLW "a"
    RETLW "l"
    RETLW "l"
    RETLW "e"
    RETLW "r"
    RETLW " "
    RETLW "Z"
    RETLW "e"
    RETLW "i"
    RETLW "t"
    RETLW "e"
    RETLW "n"
    RETLW "."
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "

    RETLW 0XFF      ;ENDEKENNZEICHEN MUSS DRIN SEIN /// ICH BENUTZE ES IMMER IN EINER TABELLE



    ORG 0X0400
;*****************************************************************************
;*                              UNTERPROGRAMM                                *
;*                       TEXT ZEILENWEISE ZUM BEISPIEL EINZELN LADEN         *
;*****************************************************************************
TABELLE_1
    MOVLW   H'04'       ;ADRESSE SPEICHERN NEUES PCLATH///
    MOVWF   PCLATH

    MOVF    NR_HELP, W  ; SPRUNGDISTANZ
    ADDWF   PCL,F       ; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  

    
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
        
;JETZT KOMMT DER TEXT
;RETLW " "    (SPACE/LEERZEICHEN) IST DIE PAUSE ZWISCHEN DEN WOERTERN
;ES KOENNEN CA. 240 ZEILEN MIT RETLW EINGETRAGEN WERDEN /// ALSO BIS SPEICHERENDE 0X3FF /// KONTROLLIERE LIST-FILE

    RETLW "I"  
    RETLW "c"
    RETLW "h"
    RETLW " "
    RETLW "b"
    RETLW "i"
    RETLW "n"
    RETLW " "
    RETLW "d"
    RETLW "e"
    RETLW "r"
    RETLW " "
    RETLW "g"
    RETLW "r"
    RETLW  B'10010100' ;
    RETLW "s"
    RETLW "s"
    RETLW "t"
    RETLW "e"
    RETLW " "
    RETLW "Q"
    RETLW "u"
    RETLW "a"
    RETLW "t"
    RETLW "s"
    RETLW "c"
    RETLW "h"
    RETLW "k"
    RETLW "o"
    RETLW "p"
    RETLW "f"
    RETLW "."
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "

    RETLW 0XFF      ;ENDEKENNZEICHEN MUSS DRIN SEIN /// ICH BENUTZE ES IMMER IN EINER TABELLE


    ORG 0X0500
;*****************************************************************************
;*                              UNTERPROGRAMM                                *
;*                       TEXT ZEILENWEISE ZUM BEISPIEL EINZELN LADEN         *
;*****************************************************************************
TABELLE_2
    MOVLW   H'05'       ;ADRESSE SPEICHERN NEUES PCLATH///DA OBEN ORG 0X0300 
    MOVWF   PCLATH

    MOVF    NR_HELP, W  ; SPRUNGDISTANZ
    ADDWF   PCL,F       ; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  

    
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
        
;JETZT KOMMT DER TEXT
;RETLW " "    (SPACE/LEERZEICHEN) IST DIE PAUSE ZWISCHEN DEN WOERTERN
;ES KOENNEN CA. 240 ZEILEN MIT RETLW EINGETRAGEN WERDEN /// ALSO BIS SPEICHERENDE 0X3FF /// KONTROLLIERE LIST-FILE

    RETLW "I"  
    RETLW "c"
    RETLW "h"
    RETLW " "
    RETLW "b"
    RETLW "i"
    RETLW "n"
    RETLW " "
    RETLW "d"
    RETLW "i"
    RETLW "e"
    RETLW " "
    RETLW "g"
    RETLW "r"
    RETLW  B'10010100' ;
    RETLW "s"
    RETLW "s"
    RETLW "t"
    RETLW "e"
    RETLW " "
    RETLW "P"
    RETLW "f"
    RETLW "e"
    RETLW "i"
    RETLW "f"
    RETLW "e"
    RETLW " "
    RETLW "d"
    RETLW "i"
    RETLW "e"
    RETLW " "
    RETLW "r"
    RETLW "u"
    RETLW "m"
    RETLW "l"
    RETLW B'10000100' ;
    RETLW "u"
    RETLW "f"
    RETLW "t"
    RETLW "."
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "


    RETLW 0XFF      ;ENDEKENNZEICHEN MUSS DRIN SEIN /// ICH BENUTZE ES IMMER IN EINER TABELLE


    ORG 0X0600
;*****************************************************************************
;*                              UNTERPROGRAMM                                *
;*                       TEXT ZEILENWEISE ZUM BEISPIEL EINZELN LADEN         *
;*****************************************************************************
TABELLE_3
    MOVLW   H'06'       ;ADRESSE SPEICHERN NEUES PCLATH///
    MOVWF   PCLATH

    MOVF    NR_HELP, W  ; SPRUNGDISTANZ
    ADDWF   PCL,F       ; AUF STELLE DES ZU LESENDEN BYTES BRINGEN  

    
;----------------------------------------------------------------------------------------------
;----------------------------------------------------------------------------------------------
        
;JETZT KOMMT DER TEXT
;RETLW " "    (SPACE/LEERZEICHEN) IST DIE PAUSE ZWISCHEN DEN WOERTERN
;ES KOENNEN CA. 240 ZEILEN MIT RETLW EINGETRAGEN WERDEN /// ALSO BIS SPEICHERENDE 0X3FF /// KONTROLLIERE LIST-FILE

    RETLW "B"  
    RETLW "a"
    RETLW "s"
    RETLW "t"
    RETLW "e"
    RETLW "l"
    RETLW "n"
    RETLW " "
    RETLW "m"
    RETLW "a"
    RETLW "c"
    RETLW "h"
    RETLW "t"
    RETLW " "
    RETLW "S"
    RETLW "p"
    RETLW "a"
    RETLW "s"
    RETLW "s"
    RETLW ","
    RETLW " "
    RETLW "w"
    RETLW "e"
    RETLW "n"
    RETLW "n"
    RETLW " "
    RETLW "e"
    RETLW "s"
    RETLW " "
    RETLW "f"
    RETLW "u"
    RETLW "n"
    RETLW "k"
    RETLW "t"
    RETLW "i"
    RETLW "o"
    RETLW "n"
    RETLW "i"
    RETLW "e"
    RETLW "r"
    RETLW "t"
    RETLW "."
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "
    RETLW " "

    RETLW 0XFF      ;ENDEKENNZEICHEN MUSS DRIN SEIN /// ICH BENUTZE ES IMMER IN EINER TABELLE




            END
